<?php
/*======================================================================*\
|| #################################################################### ||
|| # [tk] Egg Avatar                                                  # ||
|| # ---------------------------------------------------------------- # ||
|| # Originally created by [tk] Software (Hamster Powered)            # ||
|| #################################################################### ||
\*======================================================================*/ 

function egg_image($imghandler, &$imgdst, $userid, $eggdir, $filename, $filedata, $lastvisit)
{
	global $vbulletin;
	
    if ($vbulletin->options['eggavatar_optimise'])
    {
        require_once(DIR . '/includes/class_activecache.php');
        $vboptimise = vb_activecache::get_instance($vbulletin->options['_vboptimise_method']);
    }

    $imgwidth = $imghandler->fetch_width($imgdst);
    $imgheight = $imghandler->fetch_height($imgdst);

    $sprite = $imghandler->create_truecolor($imgwidth, $imgheight, $imgdst); 
    
    // get the expire time
    $exp = $vbulletin->options['eggavatar_fadetime'] * 3600;

    $eggcache = array();
    // next get any eggs/tomatos/etc we need to apply
    if ($vbulletin->options['eggavatar_optimise'])
    {
        $egg_cache = $vboptimise->fetch('eggs_' . $userid);
        if ($egg_cache) 
        { 
            $eggcache = unserialize($egg_cache);
            devdebug('[tk] Egg Avatar: Fetched eggs for userid ' . $userid);
        }
        else
        {   
            // get the oldest uncleaned egg
            $oldestegg = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "eggavatar WHERE cleaned = 0 AND userid = " . $userid);
            if ($oldestegg['dateline'] > $lastvisit)
            {
                $eggs = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "eggavatar WHERE dateline > " . $lastvisit . " AND cleaned = 0 AND userid = " . $userid);            
            }
            else 
            {
                $eggs = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "eggavatar WHERE UNIX_TIMESTAMP( ) <= (dateline + " . $exp . ") AND cleaned = 0 AND userid = " . $userid);
            }
            while($egg = $vbulletin->db->fetch_array($eggs))
            {
                $eggcache[] = $egg; 
            }
        }
    }
    else
    {
        // get the oldest uncleaned egg
        $oldestegg = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "eggavatar WHERE cleaned = 0 AND userid = " . $userid);
        if ($oldestegg['dateline'] > $lastvisit)
        {
            $eggs = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "eggavatar WHERE dateline > " . $lastvisit . " AND cleaned = 0 AND userid = " . $userid);            
        }
        else 
        {
            $eggs = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "eggavatar WHERE UNIX_TIMESTAMP( ) <= (dateline + " . $exp . ") AND cleaned = 0 AND userid = " . $userid);
        }
        while($egg = $vbulletin->db->fetch_array($eggs))
        {
            $eggcache[] = $egg;
        }        
    }
    
    $eggcount = 0;
    $cords = array();
    
    if (file_exists(DIR . '/' .$eggdir . $egg['eggtype']))
    {
        foreach($eggcache as $egg)
        {
            $eggcount++;
            
            // get the image
            $eggurl = DIR . '/' .$eggdir . $egg['eggtype'];
            // create image from the png
            $imgegg = $imghandler->load_egg($eggurl);
            $eggx = $imghandler->fetch_width($imgegg);
            $eggy = $imghandler->fetch_height($imgegg);
            
            // determine where to splat it
            if ($egg['xpos'] == 0)
            {
                // generate a random place on the image
                $egg['xpos'] = rand(0, $imgwidth - $eggx);
                $egg['ypos'] = rand(0, $imgheight - $eggy);
                
                // store them in an array so we can write them back to the database
                $cords[$egg['eggid']] = array($egg['xpos'], $egg['ypos']);
            }
        
            // splat it
            $imghandler->copy_image($sprite, $imgegg, $egg['xpos'], $egg['ypos'], 0, 0, $eggx, $eggy);
            $imghandler->destroy_image($imgegg);
        }
    }
    // save the cords
    foreach($cords as $key => $cord)
    {
        $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "eggavatar SET xpos = " . $cord[0] . ", ypos = " . $cord[1] . " WHERE eggid = " . $key);
    }

    $eggcache = array();
    if ($vbulletin->options['eggavatar_optimise'])
    {
        $eggs = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "eggavatar WHERE UNIX_TIMESTAMP( ) <= (dateline + " . $exp . ") AND cleaned = 0 AND userid = " . $userid);
        while($egg = $vbulletin->db->fetch_array($eggs))
        {
            $eggcache[] = $egg; 
        }           
        $vboptimise->set('eggs_' . $userid, serialize($eggcache));
        devdebug('[tk] Egg Avatar: Set eggs for userid ' . $userid);
    }
    
    if ($eggcount > 0)
    {
       $imghandler->destroy_image($imgdst);
       $imgdst = $imghandler->process_for_output($sprite); 
    }
    else
    {
        $imghandler->destroy_image($sprite);
    }

    return $eggcount;
}
?>